﻿/*
VERSION:		1.6

1.6		onLoadInit() passes a reference to the loaded movieClip
1.5		added "isVisible" flag to set the default visibility of the loaded image  (doesn't apply when result is BitmapData)


"EVENT" FUNCTIONS:
	onLoadInit
	onLoadError

	
RETURN VALUES:
	MovieClipLoader		Object that's loading the movieClip.  The above functions will get called upon result.
	undefined					Succeeded instantly.  No loader was needed.
	
	
DESCRIPTION:
	Creates a movieClip as specified & loads an image, SWF, or bitmapData into it.
	
	
DEFAULT RESULT:
	this.image_0
	
	
USAGE:
	#include "loadImage.as"
	loader = loadImage("test.jpg");
	
	
	success = function(){
		trace("success");
	}
	loader.onLoadInit = success;
	if(!loader)		// if:  no loader was needed
		success();
	loader.onLoadError = function(){
		trace("fail");
	}
*/
loadImage = function(file, target, newName, newDepth, isVisible)
{
	#include "nextDepth.as"
	if(isVisible == undefined)		isVisible = true;
	// resolve optional parameters
	var target = (target) ? target : this;
	var newDepth = (newDepth!=undefined) ? newDepth : nextDepth(target);
	var newName = (newName) ? newName : "image_"+newDepth;
	if(target[newName])
		target[newName].removeMovieClip();		target[newName].unloadMovie();
	// create container
	// // try movieClip linkage
	var newImage = target.attachMovie( file, newName, newDepth, {_visible:isVisible} );
	var newImage = target[newName];
	if(	newImage == target  ||
		 	newImage._width == undefined  ||
			newImage._width == 0)
	{// if:  no movieClip loaded
		var newImage = target.createEmptyMovieClip(newName, newDepth);
		newImage._visible = isVisible;
		// // direct bitmapData
		if(file.generateFilterRect != undefined)
			var image_pic = file;
		// bitmap linkage
		if(file.generateFilterRect == undefined)
			var image_pic = flash.display.BitmapData.loadBitmap( file );
		
		newImage.attachBitmap(image_pic, 0, true, true);
		if(	newImage._width == undefined  ||
				newImage._width == 0)
		{// if:  no bitmap loaded
			// external file
			var loader = new MovieClipLoader();
			var return_obj = {
				onLoadInit:function(){},
				onLoadError:function(){}
			}// return_obj
			
			var hasLoaded = false;
			loader.onLoadInit = function( loadedClip ){
				newImage._visible = isVisible;
				hasLoaded = true;
				return_obj["onLoadInit"]( loadedClip );
			}// onLoadInit()
			loader.onLoadError = function(){
				return_obj["onLoadError"]();
			}// onLoadError()
			loader.loadClip( file, newImage );
			
			if(hasLoaded)
			{// if:  instant load
				// pretend that it's not instant
				setTimeout( function(){
					return_obj["onLoadInit"]();
				}, 1);
			}// if:  instant load
			
			return return_obj;
			//return loader;
		}// if:  no bitmap loaded
	}// if:  no movieClip loaded
}// loadImage()